/*
 * Decompiled with CFR 0.152.
 */
package com.joconner.i18n;

import com.joconner.i18n.PackageableResourceControl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Utf8ResourceBundleControl
extends PackageableResourceControl {
    public Utf8ResourceBundleControl() {
    }

    public Utf8ResourceBundleControl(boolean isPackageBased) {
        super(isPackageBased);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if (format.equals("java.class")) {
            bundle = super.newBundle(baseName, locale, format, loader, reload);
        } else if (format.equals("java.properties")) {
            String resourceName;
            String string = resourceName = bundleName.contains("://") ? null : this.toResourceName(bundleName, "properties");
            if (resourceName == null) {
                return bundle;
            }
            ClassLoader classLoader = loader;
            InputStream stream = null;
            stream = reload ? this.reload(resourceName, classLoader) : classLoader.getResourceAsStream(resourceName);
            if (stream != null) {
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                try {
                    bundle = new PropertyResourceBundle(reader);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        return bundle;
    }

    InputStream reload(String resourceName, ClassLoader classLoader) throws IOException {
        URLConnection connection;
        InputStream stream = null;
        URL url = classLoader.getResource(resourceName);
        if (url != null && (connection = url.openConnection()) != null) {
            connection.setUseCaches(false);
            stream = connection.getInputStream();
        }
        return stream;
    }
}

